#include "gui/widgets/poster.h"
#include "core/anime_db.h"
#include "core/http.h"
#include "core/session.h"
#include "core/strings.h"
#include "gui/widgets/clickable_label.h"
#include <QByteArray>
#include <QDebug>
#include <QDesktopServices>
#include <QFrame>
#include <QHBoxLayout>
#include <QLabel>
#include <QMessageBox>
#include <QPixmap>
#include <QThread>
#include <QUrl>
#include <curl/curl.h>

Poster::Poster(QWidget* parent) : QFrame(parent) {
	QHBoxLayout* layout = new QHBoxLayout(this);
	layout->setContentsMargins(1, 1, 1, 1);

	setCursor(Qt::PointingHandCursor);
	setFixedSize(150, 225);
	setFrameShape(QFrame::Box);
	setFrameShadow(QFrame::Plain);

	label = new ClickableLabel(this);
	label->setAlignment(Qt::AlignCenter);
	layout->addWidget(label);
}

Poster::Poster(const Anime::Anime& anime, QWidget* parent) : Poster(parent) {
	SetAnime(anime);
}

void Poster::SetAnime(const Anime::Anime& anime) {
	{
		QByteArray* ba = new QByteArray;

		QThread* thread = QThread::create([ba, anime] {
			*ba = HTTP::Get(anime.GetPosterUrl(), {});
		});

		connect(thread, &QThread::finished, this, [this, ba] {
			ImageDownloadFinished(*ba);
			delete ba;
		});

		thread->start();
	}

	label->disconnect();
	connect(label, &ClickableLabel::clicked, this,
	        [anime] { QDesktopServices::openUrl(Strings::ToQString(anime.GetServiceUrl())); });
}

void Poster::ImageDownloadFinished(const QByteArray& arr) {
	img.loadFromData(arr);
	RenderToLabel();
}

void Poster::RenderToLabel() {
	const QPixmap pixmap = QPixmap::fromImage(img);
	if (pixmap.isNull())
		return;
	label->setPixmap(pixmap.scaled(label->size(), Qt::KeepAspectRatioByExpanding, Qt::SmoothTransformation));
}

void Poster::resizeEvent(QResizeEvent*) {
	RenderToLabel();
}

#include "gui/widgets/moc_poster.cpp"
