#ifndef __anilist_h
#define __anilist_h
#include <curl/curl.h>
#include "anime.h"
#include "json.h"
class AniList {
	public:
		int Authorize();
		int GetUserId(std::string name);
		int UpdateAnimeList(std::vector<AnimeList>* anime_lists, int id);

	private:
		static size_t CurlWriteCallback(void *contents, size_t size, size_t nmemb, void *userdata);
		enum AnimeWatchingStatus ConvertWatchingStatusToEnum(std::string status);
		enum AnimeAiringStatus ConvertAiringStatusToEnum(std::string status);
		enum AnimeFormat ConvertFormatToEnum(std::string format);
		enum AnimeSeason ConvertSeasonToEnum(std::string season);
		std::string SendRequest(std::string data);
		CURL* curl;
		CURLcode res;
};
#endif // __anilist_h
