#include "core/anime_db.h"
#include "core/anime.h"

namespace Anime {

int Database::GetTotalAnimeAmount() {
	int total = 0;
	for (const auto& [id, anime] : items) {
		if (anime.IsInUserList())
			total++;
	}
	return total;
}

int Database::GetTotalEpisodeAmount() {
	int total = 0;
	for (const auto& [id, anime] : items) {
		if (anime.IsInUserList()) {
			total += anime.GetUserRewatchedTimes() * anime.GetEpisodes();
			total += anime.GetUserProgress();
		}
	}
	return total;
}

/* Returns the total watched amount in minutes. */
int Database::GetTotalWatchedAmount() {
	int total = 0;
	for (const auto& [id, anime] : items) {
		if (anime.IsInUserList()) {
			total += anime.GetDuration() * anime.GetUserProgress();
			total += anime.GetEpisodes() * anime.GetDuration() * anime.GetUserRewatchedTimes();
		}
	}
	return total;
}

/* Returns the total planned amount in minutes.
   Note that we should probably limit progress to the
   amount of episodes, as AniList will let you
   set episode counts up to 32768. But that should
   rather be handled elsewhere. */
int Database::GetTotalPlannedAmount() {
	int total = 0;
	for (const auto& [id, anime] : items) {
		if (anime.IsInUserList())
			total += anime.GetDuration() * (anime.GetEpisodes() - anime.GetUserProgress());
	}
	return total;
}

/* I'm sure many will appreciate this being called an
   "average" instead of a "mean" */
double Database::GetAverageScore() {
	double avg = 0;
	int amt = 0;
	for (const auto& [id, anime] : items) {
		if (anime.IsInUserList() && anime.GetUserScore()) {
			avg += anime.GetUserScore();
			amt++;
		}
	}
	return avg / amt;
}

double Database::GetScoreDeviation() {
	double squares_sum = 0, avg = GetAverageScore();
	int amt = 0;
	for (const auto& [id, anime] : items) {
		if (anime.GetUserScore()) {
			squares_sum += std::pow((double)anime.GetUserScore() - avg, 2);
			amt++;
		}
	}
	return (amt > 0) ? std::sqrt(squares_sum / amt) : 0;
}

} // namespace Anime