#include "gui/pages/statistics.h"
#include "gui/pages/anime_list.h"
#include "gui/ui_utils.h"
#include "session.h"
#include <QString>
#include <QTextDocument>
#include <QTextStream>
#include <QTimer>
#include <QVBoxLayout>
#include <QWidget>
#include <sstream>

StatisticsWidget::StatisticsWidget(QWidget* parent) : QFrame(parent) {
	setLayout(new QVBoxLayout);

	setFrameShape(QFrame::Panel);
	setFrameShadow(QFrame::Sunken);

	UiUtils::LabelledTextParagraph* anime_list_paragraph = new UiUtils::LabelledTextParagraph(
		"Anime list",
		"Anime count:\nEpisode count:\nTime spent watching:\nTime to complete:\nAverage score:\nScore deviation:", "",
		this);
	anime_list_data = anime_list_paragraph->GetParagraph();

	UiUtils::LabelledTextParagraph* application_paragraph =
		new UiUtils::LabelledTextParagraph("Weeaboo", "Uptime:", "", this);
	application_data = application_paragraph->GetParagraph();

	layout()->addWidget(anime_list_paragraph);
	layout()->addWidget(application_paragraph);
	((QBoxLayout*)layout())->addStretch();

	QPalette pal = QPalette();
	pal.setColor(QPalette::Window, Qt::white);
	setAutoFillBackground(true);
	setPalette(pal);

	QTimer* timer = new QTimer(this);
	connect(timer, &QTimer::timeout, this, [this] {
		if (isVisible())
			UpdateStatistics();
	});
	timer->start(1000); // update statistics every second
}

void StatisticsWidget::showEvent(QShowEvent*) {
	UpdateStatistics();
}

/* me abusing macros :) */
#define ADD_TIME_SEGMENT(r, x, s, p)                                                                                   \
	if (x > 0)                                                                                                         \
	r << x << ((x == 1) ? s : p)
std::string StatisticsWidget::MinutesToDateString(int minutes) {
	/* ew */
	int years = (minutes * (1 / 525949.2F));
	int months = (minutes * (1 / 43829.1F)) - (years * 12);
	int days = (minutes * (1 / 1440.0F)) - (years * 365.2425F) - (months * 30.436875F);
	int hours = (minutes * (1 / 60.0F)) - (years * 8765.82F) - (months * 730.485F) - (days * 24);
	int rest_minutes = (minutes) - (years * 525949.2F) - (months * 43829.1F) - (days * 1440) - (hours * 60);
	std::ostringstream return_stream;
	ADD_TIME_SEGMENT(return_stream, years, " year ", " years ");
	ADD_TIME_SEGMENT(return_stream, months, " month ", " months ");
	ADD_TIME_SEGMENT(return_stream, days, " day ", " days ");
	ADD_TIME_SEGMENT(return_stream, hours, " hour ", " hours ");
	if (rest_minutes > 0 || return_stream.str().size() == 0)
		return_stream << rest_minutes << ((rest_minutes == 1) ? " minute" : " minutes");
	return return_stream.str();
}

std::string StatisticsWidget::SecondsToDateString(int seconds) {
	/* this is all fairly unnecessary, but works:tm: */
	std::chrono::duration<int, std::ratio<1>> int_total_mins(seconds);
	auto int_years = std::chrono::duration_cast<std::chrono::years>(int_total_mins);
	auto int_months = std::chrono::duration_cast<std::chrono::months>(int_total_mins - int_years);
	auto int_days = std::chrono::duration_cast<std::chrono::days>(int_total_mins - int_years - int_months);
	auto int_hours = std::chrono::duration_cast<std::chrono::hours>(int_total_mins - int_years - int_months - int_days);
	auto int_minutes = std::chrono::duration_cast<std::chrono::minutes>(int_total_mins - int_years - int_months -
																		int_days - int_hours);
	auto int_seconds = std::chrono::duration_cast<std::chrono::seconds>(int_total_mins - int_years - int_months -
																		int_days - int_hours - int_minutes);
	std::ostringstream return_stream;
	ADD_TIME_SEGMENT(return_stream, int_years, " year ", " years ");
	ADD_TIME_SEGMENT(return_stream, int_months, " month ", " months ");
	ADD_TIME_SEGMENT(return_stream, int_days, " day ", " days ");
	ADD_TIME_SEGMENT(return_stream, int_hours, " hour ", " hours ");
	ADD_TIME_SEGMENT(return_stream, int_minutes, " minute ", " minutes ");
	if (int_seconds.count() > 0 || return_stream.str().size() == 0)
		return_stream << int_seconds.count() << ((int_seconds.count() == 1) ? " second" : " seconds");
	return return_stream.str();
}
#undef ADD_TIME_SEGMENT

void StatisticsWidget::UpdateStatistics() {
	/* Anime list */
	QString string = "";
	QTextStream ts(&string);
	ts << Anime::db->GetTotalAnimeAmount() << '\n';
	ts << Anime::db->GetTotalEpisodeAmount() << '\n';
	ts << MinutesToDateString(Anime::db->GetTotalWatchedAmount()).c_str() << '\n';
	ts << MinutesToDateString(Anime::db->GetTotalPlannedAmount()).c_str() << '\n';
	ts << Anime::db->GetAverageScore() << '\n';
	ts << Anime::db->GetScoreDeviation();
	UiUtils::SetPlainTextEditData(anime_list_data, string);

	/* Application */
	// UiUtils::SetPlainTextEditData(application_data, QString::number(session.uptime() / 1000));
	UiUtils::SetPlainTextEditData(application_data, QString(SecondsToDateString(session.uptime() / 1000).c_str()));
}

#include "gui/pages/moc_statistics.h"
