#include "gui/translate/anilist.h"

namespace Translate::AniList {

Anime::SeriesStatus ToSeriesStatus(std::string status) {
	std::unordered_map<std::string, Anime::SeriesStatus> map = {
	    {"FINISHED",         Anime::SeriesStatus::FINISHED        },
	    {"RELEASING",        Anime::SeriesStatus::RELEASING       },
	    {"NOT_YET_RELEASED", Anime::SeriesStatus::NOT_YET_RELEASED},
	    {"CANCELLED",        Anime::SeriesStatus::CANCELLED       },
	    {"HIATUS",           Anime::SeriesStatus::HIATUS          }
    };

	if (!map.contains(status))
		return Anime::SeriesStatus::UNKNOWN;
	return map[status];
}

Anime::SeriesSeason ToSeriesSeason(std::string season) {
	std::unordered_map<std::string, Anime::SeriesSeason> map = {
	    {"WINTER", Anime::SeriesSeason::WINTER},
	    {"SPRING", Anime::SeriesSeason::SPRING},
	    {"SUMMER", Anime::SeriesSeason::SUMMER},
	    {"FALL",   Anime::SeriesSeason::FALL  }
    };

	if (!map.contains(season))
		return Anime::SeriesSeason::UNKNOWN;
	return map[season];
}

Anime::SeriesFormat ToSeriesFormat(std::string format) {
	std::unordered_map<std::string, enum Anime::SeriesFormat> map = {
	    {"TV",       Anime::SeriesFormat::TV      },
        {"TV_SHORT", Anime::SeriesFormat::TV_SHORT},
	    {"MOVIE",    Anime::SeriesFormat::MOVIE   },
        {"SPECIAL",  Anime::SeriesFormat::SPECIAL },
	    {"OVA",      Anime::SeriesFormat::OVA     },
        {"ONA",      Anime::SeriesFormat::ONA     },
	    {"MUSIC",    Anime::SeriesFormat::MUSIC   },
        {"MANGA",    Anime::SeriesFormat::MANGA   },
	    {"NOVEL",    Anime::SeriesFormat::NOVEL   },
        {"ONE_SHOT", Anime::SeriesFormat::ONE_SHOT}
    };

	if (!map.contains(format))
		return Anime::SeriesFormat::UNKNOWN;
	return map[format];
}

} // namespace Translate::AniList