#include "sys/osx/dark_theme.h"
#import <Cocoa/Cocoa.h>

namespace osx {

bool DarkThemeAvailable() {
	if (@available(macOS 10.14, *))
		return true;
	else
		return false;
}

bool IsInDarkTheme() {
	if (@available(macOS 10.14, *)) {
		auto appearance = [NSApp.effectiveAppearance
		    bestMatchFromAppearancesWithNames:@[ NSAppearanceNameAqua, NSAppearanceNameDarkAqua ]];
		return [appearance isEqualToString:NSAppearanceNameDarkAqua];
	}
	return false;
}

void SetToDarkTheme() {
	// https://stackoverflow.com/questions/55925862/how-can-i-set-my-os-x-application-theme-in-code
	if (@available(macOS 10.14, *)) {
		[NSApp setAppearance:[NSAppearance appearanceNamed:NSAppearanceNameDarkAqua]];
	}
}

void SetToLightTheme() {
	// https://stackoverflow.com/questions/55925862/how-can-i-set-my-os-x-application-theme-in-code
	if (__builtin_available(macOS 10.14, *)) {
		[NSApp setAppearance:[NSAppearance appearanceNamed:NSAppearanceNameAqua]];
	}
}

void SetToAutoTheme() {
	if (@available(macOS 10.14, *)) {
		[NSApp setAppearance:nil];
	}
}

} // namespace osx
