#include "services/services.h"
#include "core/session.h"
#include "gui/translate/anime.h"
#include "services/anilist.h"
#include "services/kitsu.h"

namespace Services {

void Synchronize() {
	session.SetStatusBar(Translate::ToString(session.config.service) + ": Retrieving anime list...");

	switch (session.config.service) {
		case Anime::Service::AniList: AniList::GetAnimeList(); break;
		case Anime::Service::Kitsu: Kitsu::GetAnimeList(); break;
		default: break;
	}
}

bool RetrieveAnimeMetadata(int id) {
	switch (session.config.service) {
		case Anime::Service::Kitsu:	return Kitsu::RetrieveAnimeMetadata(id);
		default: return false;
	}
}

std::vector<int> Search(const std::string& search) {
	session.SetStatusBar(Translate::ToString(session.config.service) + ": Requesting search query...");

	switch (session.config.service) {
		case Anime::Service::AniList: return AniList::Search(search);
		case Anime::Service::Kitsu: return Kitsu::Search(search);
		default: return {};
	}
}

std::vector<int> GetSeason(Anime::SeriesSeason season, Date::Year year) {
	session.SetStatusBar(Translate::ToString(session.config.service) + ": Retrieving anime season data...");

	switch (session.config.service) {
		case Anime::Service::AniList: return AniList::GetSeason(season, year);
		case Anime::Service::Kitsu: return Kitsu::GetSeason(season, year);
		default: return {};
	}
}

void UpdateAnimeEntry(int id) {
	session.SetStatusBar(Translate::ToString(session.config.service) + ": Updating remote anime entry...");

	switch (session.config.service) {
		case Anime::Service::AniList: AniList::UpdateAnimeEntry(id); break;
		case Anime::Service::Kitsu: Kitsu::UpdateAnimeEntry(id); break;
		default: break;
	}
}

}; // namespace Services
