#ifndef ANIMONE_ANIMONE_MEDIA_H_
#define ANIMONE_ANIMONE_MEDIA_H_

#include "animone/types.h"

#include <chrono>
#include <functional>
#include <string>
#include <vector>

namespace animone {

// XXX where is this used?
using media_time_t = std::chrono::milliseconds;

enum class MediaInfoType {
	Unknown,
	File,
	Tab,
	Title,
	Url
};

struct ANIMONE_API MediaInfo {
	MediaInfoType type = MediaInfoType::Unknown;
	std::string value;
};

struct ANIMONE_API Media {
	std::vector<MediaInfo> information;
};

} // namespace animone

#endif // ANIMONE_ANIMONE_MEDIA_H_
