#include "track/media.h"
#include "core/filesystem.h"
#include "core/strings.h"
#include "animia.h"
#include "anitomy/anitomy.h"
#include <string>
#include <vector>

namespace Track {
namespace Media {

Filesystem::Path GetCurrentPlaying() {
	/* getting all open files */
	std::vector<int> pids = Animia::get_all_pids();
	for (int i : pids) {
		if (Animia::get_process_name(i) == "mpc-hc64.exe") {
			std::vector<std::string> files = Animia::filter_system_files(Animia::get_open_files(i));
			for (std::string s : files) {
				Filesystem::Path p(s);
				if (p.Extension() == "mkv")
					return p;
			}
		}
	}
	return Filesystem::Path();
}

std::string GetFileTitle(Filesystem::Path path) {
	anitomy::Anitomy anitomy;
	anitomy.Parse(Strings::ToWstring(path.Basename()));

	const auto& elements = anitomy.elements();

	return Strings::ToUtf8String(elements.get(anitomy::kElementAnimeTitle));
}

} // namespace Media
} // namespace Track
