#include "gui/dialog/information.h"
#include "core/anime.h"
#include "core/strings.h"
#include "gui/pages/anime_list.h"
#include "gui/translate/anime.h"
#include "gui/ui_utils.h"
#include "gui/window.h"
#include <QDebug>
#include <QDialogButtonBox>
#include <QPlainTextEdit>
#include <QTextStream>
#include <QVBoxLayout>
#include <functional>

InformationDialog::InformationDialog(Anime::Anime& anime, std::function<void()> accept, QWidget* parent)
    : QDialog(parent) {
	setFixedSize(842, 613);
	setWindowTitle(tr("Anime Information"));
	setWindowFlags(Qt::Dialog | Qt::CustomizeWindowHint | Qt::WindowTitleHint | Qt::WindowCloseButtonHint);

	{
		QPalette pal;
		pal.setColor(QPalette::Window, Qt::white);
		setPalette(pal);
	}

	QWidget* widget = new QWidget(this);

	/* "sidebar", includes... just the anime image :) */
	QWidget* sidebar = new QWidget(widget);
	sidebar->setFixedWidth(175);

	/* main widget */
	QWidget* main_widget = new QWidget(widget);

	{
		QPalette pal;
		pal.setColor(QPalette::Window, Qt::white);
		main_widget->setPalette(pal);
	}

	main_widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

	/* anime title header text */
	UiUtils::Paragraph* anime_title =
	    new UiUtils::Paragraph(QString::fromUtf8(anime.GetUserPreferredTitle().c_str()), main_widget);
	anime_title->setReadOnly(true);
	anime_title->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	anime_title->setWordWrapMode(QTextOption::NoWrap);
	anime_title->setFrameShape(QFrame::NoFrame);
	anime_title->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);
	anime_title->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	anime_title->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

	{
		QFont font(anime_title->font());
		font.setPointSize(12);
		anime_title->setFont(font);
	}

	{
		QPalette pal;
		pal.setColor(QPalette::Window, QColor(255, 255, 255, 0));
		pal.setColor(QPalette::WindowText, Qt::blue);
	}

	/* tabbed widget */
	QTabWidget* tabbed_widget = new QTabWidget(main_widget);
	tabbed_widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);

	/* main info tab */
	QWidget* main_information_widget = new QWidget(tabbed_widget);
	main_information_widget->setLayout(new QVBoxLayout);

	/* alt titles */
	main_information_widget->layout()->addWidget(new UiUtils::SelectableTextParagraph(
	    "Alternative titles", QString::fromUtf8(Strings::Implode(anime.GetTitleSynonyms(), ", ").c_str()),
	    main_information_widget));

	/* details */
	QString details_data;
	QTextStream details_data_s(&details_data);
	details_data_s << Translate::ToString(anime.GetFormat()).c_str() << "\n"
	               << anime.GetEpisodes() << "\n"
	               << Translate::ToString(anime.GetUserStatus()).c_str() << "\n"
	               << Translate::ToString(anime.GetSeason()).c_str() << " " << anime.GetAirDate().GetYear()
	               << "\n"
	               << Strings::Implode(anime.GetGenres(), ", ").c_str() << "\n"
	               << anime.GetAudienceScore() << "%";
	main_information_widget->layout()->addWidget(new UiUtils::LabelledTextParagraph(
	    "Details", "Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:", details_data, main_information_widget));

	/* synopsis */
	UiUtils::SelectableTextParagraph* synopsis = new UiUtils::SelectableTextParagraph(
	    "Synopsis", QString::fromUtf8(anime.GetSynopsis().c_str()), main_information_widget);

	synopsis->GetParagraph()->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	((QVBoxLayout*)main_information_widget->layout())->addWidget(synopsis);

	QWidget* settings_widget = new QWidget(tabbed_widget);

	tabbed_widget->addTab(main_information_widget, "Main information");
	tabbed_widget->addTab(settings_widget, "My list and settings");

	QVBoxLayout* main_layout = new QVBoxLayout;
	main_layout->addWidget(anime_title);
	main_layout->addWidget(tabbed_widget);
	main_layout->setMargin(0);
	main_widget->setLayout(main_layout);

	QHBoxLayout* layout = new QHBoxLayout;
	layout->addWidget(sidebar);
	layout->addWidget(main_widget);
	widget->setLayout(layout);

	QDialogButtonBox* button_box = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, this);
	connect(button_box, &QDialogButtonBox::accepted, this, [this, accept] {
		accept();
		QDialog::accept();
	});
	connect(button_box, &QDialogButtonBox::rejected, this, &QDialog::reject);

	QVBoxLayout* buttons_layout = new QVBoxLayout;
	buttons_layout->addWidget(widget);
	buttons_layout->addWidget(button_box, 0, Qt::AlignBottom);
	setLayout(buttons_layout);
}

#include "gui/dialog/moc_information.cpp"
