#include "core/anime.h"
#include "gui/translate/anime.h"

namespace Translate {

std::string ToString(const Anime::ListStatus status) {
	switch (status) {
		case Anime::ListStatus::NOT_IN_LIST: return "Not in list";
		case Anime::ListStatus::CURRENT: return "Currently watching";
		case Anime::ListStatus::PLANNING: return "Plan to watch";
		case Anime::ListStatus::COMPLETED: return "Completed";
		case Anime::ListStatus::DROPPED: return "Dropped";
		case Anime::ListStatus::PAUSED: return "On hold";
		default: return "";
	}
}

std::string ToString(const Anime::SeriesFormat format) {
	switch (format) {
		case Anime::SeriesFormat::UNKNOWN: return "Unknown";
		case Anime::SeriesFormat::TV: return "TV";
		case Anime::SeriesFormat::TV_SHORT: return "TV short";
		case Anime::SeriesFormat::OVA: return "OVA";
		case Anime::SeriesFormat::MOVIE: return "Movie";
		case Anime::SeriesFormat::SPECIAL: return "Special";
		case Anime::SeriesFormat::ONA: return "ONA";
		case Anime::SeriesFormat::MUSIC: return "Music";
		default: return "";
	}
}

std::string ToString(const Anime::SeriesSeason season) {
	switch (season) {
		case Anime::SeriesSeason::UNKNOWN: return "Unknown";
		case Anime::SeriesSeason::WINTER: return "Winter";
		case Anime::SeriesSeason::SUMMER: return "Summer";
		case Anime::SeriesSeason::FALL: return "Fall";
		case Anime::SeriesSeason::SPRING: return "Spring";
		default: return "";
	}
}

std::string ToString(const Anime::SeriesStatus status) {
	switch (status) {
		case Anime::SeriesStatus::UNKNOWN: return "Unknown";
		case Anime::SeriesStatus::RELEASING: return "Currently airing";
		case Anime::SeriesStatus::FINISHED: return "Finished airing";
		case Anime::SeriesStatus::NOT_YET_RELEASED: return "Not yet aired";
		case Anime::SeriesStatus::CANCELLED: return "Cancelled";
		case Anime::SeriesStatus::HIATUS: return "On hiatus";
		default: return "";
	}
}

} // namespace Translate