#include "core/json.h"

namespace JSON {

std::string GetString(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, std::string def) {
	if (json.contains(ptr) && json[ptr].is_string())
		return json[ptr].get<std::string>();
	else
		return def;
}

int GetInt(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, int def) {
	if (json.contains(ptr) && json[ptr].is_number())
		return json[ptr].get<int>();
	else
		return def;
}

bool GetBoolean(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, bool def) {
	if (json.contains(ptr) && json[ptr].is_boolean())
		return json[ptr].get<bool>();
	else
		return def;
}

double GetDouble(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, double def) {
	if (json.contains(ptr) && json[ptr].is_number())
		return json[ptr].get<double>();
	else
		return def;
}

} // namespace JSON
