#include "gui/pages/now_playing.h"
#include "core/anime_db.h"
#include "gui/widgets/anime_info.h"
#include "gui/widgets/text.h"
#include <QLabel>
#include <QStackedWidget>
#include <QVBoxLayout>
#include <QWidget>

namespace NowPlayingPages {

class Default : public QWidget {
		Q_OBJECT

	public:
		Default(QWidget* parent = nullptr);
};

class Playing : public QWidget {
		Q_OBJECT

	public:
		Playing(QWidget* parent = nullptr);
		void SetPlayingAnime(int id);

	private:
		std::unique_ptr<AnimeInfoWidget> info = nullptr;
};

Default::Default(QWidget* parent) : QWidget(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);
	layout->setContentsMargins(0, 0, 0, 0);

	layout->addStretch();
}

Playing::Playing(QWidget* parent) : QWidget(parent) {
	QHBoxLayout* layout = new QHBoxLayout(this);
	
	layout->setContentsMargins(0, 0, 0, 0);
}

void Playing::SetPlayingAnime(int id) {
	if (info.get())
		layout()->removeWidget(info.get());
	info.reset(new AnimeInfoWidget(Anime::db.items[id]));
	layout()->addWidget(info.get());
}

} // namespace NowPlayingPages

NowPlayingPage::NowPlayingPage(QWidget* parent) : QFrame(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);

	setFrameShape(QFrame::Box);
	setFrameShadow(QFrame::Sunken);

	QPalette pal = QPalette();
	pal.setColor(QPalette::Window, pal.color(QPalette::Base));
	setPalette(pal);
	setAutoFillBackground(true);

	TextWidgets::Title* title = new TextWidgets::Title(tr("Now Playing"), this);
	layout->addWidget(title);

	stack = new QStackedWidget(this);
	stack->addWidget(new NowPlayingPages::Default(stack));
	stack->addWidget(new NowPlayingPages::Playing(stack));
	layout->addWidget(stack);

	layout->addStretch();
	SetDefault();
}

void NowPlayingPage::SetDefault() {
	stack->setCurrentIndex(0);
}

void NowPlayingPage::SetPlaying(int id) {
	reinterpret_cast<NowPlayingPages::Playing*>(stack->widget(1))->SetPlayingAnime(id);
	stack->setCurrentIndex(1);
}

#include "gui/pages/moc_now_playing.cpp"
#include "now_playing.moc"
