#ifndef __animia__animia__util__osx_h
#define __animia__animia__util__osx_h

#include "animia/types.h"
#include <string>

#ifdef HAVE_COREFOUNDATION
#include <CoreFoundation/CoreFoundation.h>
#endif

namespace animia::internal::osx::util {

#ifdef HAVE_COREFOUNDATION

/* I don't want to have to call CFRelease */
template<typename T>
struct CFDeleter {
	using pointer = T;
	void operator()(pointer p) { CFRelease(p); }
}

template<typename T>
typedef CFReference = std::unique_ptr<T, CFDeleter>;

template<typename T>
bool GetCFNumber(const CFNumber& num, T& result) {
	if (!num)
		return false;

	CFNumberType type = CFNumberGetType(num);
	if (!CFNumberGetValue(num, type, result))
		return false;

	return true;
}

bool StringFromCFString(CFStringRef string, std::string& result);

#endif // HAVE_COREFOUNDATION

bool GetProcessName(pid_t pid, std::string& result);

}

#endif // __animia__animia__util__osx_h
