#ifndef ANIMONE_ANIMONE_H_
#define ANIMONE_ANIMONE_H_

#include "animone/media.h"
#include "animone/player.h"
#include "animone/types.h"

namespace animone {

enum class ResultType {
	Process,
	Window
};

struct Process {
	internal::pid_t pid = 0; /* pid_t == DWORD on Windows, from <sys/types.h> everywhere else */
	std::string name;
};

struct Window {
	unsigned int id = 0;
	std::string class_name;
	std::string text; /* title bar text */
};

struct Result {
	Player player;
	Process process;
	Window window; /* has nothing under process mode */
	std::vector<Media> media;
};

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results);

} // namespace animone

#endif // ANIMONE_ANIMONE_H_
