#ifndef ANIMONE_ANIMONE_FD_H_
#define ANIMONE_ANIMONE_FD_H_

#include <functional>
#include <set>
#include <string>

#include "animone/types.h"

namespace animone {

struct Process;

namespace internal {

struct OpenFile {
	pid_t pid = 0;
	std::string path;
};

using process_proc_t = std::function<bool(const Process&)>;

using open_file_proc_t = std::function<bool(const OpenFile&)>;

bool GetProcessName(pid_t pid, std::string& name);
bool EnumerateOpenProcesses(process_proc_t process_proc);
bool EnumerateOpenFiles(const std::set<pid_t>& pids, open_file_proc_t open_file_proc);

} // namespace internal

} // namespace animone

#endif // ANIMONE_ANIMONE_FD_H_
