#include "animone/win.h"

#ifdef WIN32
#	include "animone/win/win32.h"
#endif

#ifdef MACOSX
#	include "animone/win/quartz.h"
#endif

#ifdef X11
#	include "animone/win/x11.h"
#endif

#include <iostream>

namespace animone::internal {

bool EnumerateWindows(window_proc_t window_proc) {
	bool success = false;

	std::cout << "enumerating windows" << std::endl;

#ifdef WIN32
	success |= win32::EnumerateWindows(window_proc);
#endif

#ifdef MACOSX
	success |= quartz::EnumerateWindows(window_proc);
#endif

#ifdef X11
	success |= x11::EnumerateWindows(window_proc);
#endif

	return success;
}

} // namespace animone::internal
