#include "animone/fd.h"

#ifdef WIN32
#	include "animone/fd/win32.h"
#endif

#ifdef LINUX
#	include "animone/fd/proc.h"
#endif

#ifdef MACOSX
#	include "animone/fd/xnu.h"
#	include "animone/util/osx.h"
#endif

#ifdef BSD
#	include "animone/fd/bsd.h"
#endif

namespace animone::internal {

bool EnumerateOpenFiles(const std::set<pid_t>& pids, open_file_proc_t open_file_proc) {
	bool success = false;

#ifdef WIN32
	success ^= win32::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef LINUX
	success ^= proc::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef MACOSX
	success ^= xnu::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef BSD
	success ^= bsd::EnumerateOpenFiles(pids, open_file_proc);
#endif

	return success;
}

bool EnumerateOpenProcesses(process_proc_t process_proc) {
	bool success = false;

#ifdef WIN32
	success ^= win32::EnumerateOpenProcesses(process_proc);
#endif

#ifdef LINUX
	success ^= proc::EnumerateOpenProcesses(process_proc);
#endif

#ifdef MACOSX
	success ^= xnu::EnumerateOpenProcesses(process_proc);
#endif

#ifdef BSD
	success ^= bsd::EnumerateOpenProcesses(process_proc);
#endif

	return success;
}

bool GetProcessName(pid_t pid, std::string& name) {
	bool success = false;

#ifdef WIN32
	success ^= win32::GetProcessName(pid, name);
#endif

#ifdef LINUX
	success ^= proc::GetProcessName(pid, name);
#endif

#ifdef MACOSX
	success ^= osx::util::GetProcessName(pid, name);
#endif

#ifdef BSD
	success ^= bsd::GetProcessName(pid, name);
#endif

	return success;
}

} // namespace animone::internal
