#include "core/config.h"
#include "gui/translate/config.h"

#include <unordered_map>

namespace Translate {

Themes ToTheme(const std::string& theme) {
	const std::unordered_map<std::string, Themes> map = {
		{"Default", Themes::OS   },
		{"Light",   Themes::LIGHT},
		{"Dark",    Themes::DARK }
	};

	if (map.find(theme) == map.end())
		return Themes::OS;
	return map.at(theme);
}

std::string ToString(const Themes& theme) {
	switch (theme) {
		default:
		case Themes::OS:    return "Default";
		case Themes::LIGHT: return "Light";
		case Themes::DARK:  return "Dark";
	}
}

}
