#ifndef __animia__animia__matroska_h
#define __animia__animia__matroska_h

#include <chrono>
#include <cstdint>
#include <string>
#include <vector>

namespace animia::matroska {

namespace detail {

using timecode_scale_t = std::chrono::duration<float, std::nano>;
constexpr uint32_t kDefaultTimecodeScale = 1000000;  // 1 milliseconds

enum ElementId {
	// EBML Header
	EL_EBML = 0x1A45DFA3,
	// Segment
	EL_SEGMENT = 0x18538067,
	// Segment Information
	EL_INFO = 0x1549A966,
	EL_TIMECODESCALE = 0x2AD7B1,
	EL_DURATION = 0x4489,
	EL_TITLE = 0x7BA9,
	// Track
	EL_TRACKS = 0x1654AE6B,
	EL_TRACKENTRY = 0xAE,
	EL_TRACKTYPE = 0x83,
	EL_TRACKNAME = 0x536E
};

enum TrackType {
	kVideo = 1
};

class Buffer {
	public:
		Buffer(size_t size);

		uint8_t* data();
		size_t pos() const;
		size_t size() const;
		void skip(size_t size);

		bool read_encoded_value(uint32_t& value, bool clear_leading_bits);
		uint32_t read_uint32(const size_t size);
		float read_float(const size_t size);
		std::string read_string(const size_t size);

	private:
		std::vector<uint8_t> data_;
		size_t pos_ = 0;
};

} // namespace detail

using duration_t = std::chrono::duration<float, std::milli>;

struct Info {
	duration_t duration = duration_t::zero();
	std::string title;
	std::string video_track_name;
};

bool ReadInfoFromFile(const std::string& path, Info& info);

}

#endif // __animia__animia__matroska_h
