#ifndef __animia__animia__win32__util_h
#define __animia__animia__win32__util_h

#include <memory>
#include <string>
#include <type_traits>

#include <windows.h>

namespace animia::win::detail {

struct HandleDeleter {
	void operator()(HANDLE p) const { ::CloseHandle(p); }
};

using Handle = std::unique_ptr<HANDLE, HandleDeleter>;

/* ----------- Alternative to Microsoft::WRL::ComPtr ------------- */
template <typename T>
struct ComInterfaceDeleter {
	static_assert(std::is_base_of<IUnknown, T>::value, "Invalid COM interface");
	void operator()(T* p) const { if (p) p->Release(); }
};

template <typename T>
using ComInterface = std::unique_ptr<T, ComInterfaceDeleter<T>>;
/* --------------------------------------------------------------- */

std::wstring GetFileNameFromPath(const std::wstring& path);
std::wstring GetFileNameWithoutExtension(const std::wstring& filename);
bool IsSystemDirectory(const std::wstring& path);

std::string ToUtf8String(const std::wstring& str);

}

#endif // __animia__animia__win32__util_h
