#ifndef __animia__animia__win32__ui_auto_h
#define __animia__animia__win32__ui_auto_h

/* "UI automation" == web browser stuff.. */

#include <functional>
#include <string>

#include <windows.h>

namespace animia::win::detail {

enum class WebBrowserInformationType {
	Address,
	Tab,
	Title,
};

struct WebBrowserInformation {
	WebBrowserInformationType type = WebBrowserInformationType::Title;
	std::string value;
};

using web_browser_proc_t = std::function<void(const WebBrowserInformation&)>;

bool GetWebBrowserInformation(HWND hwnd, web_browser_proc_t web_browser_proc);

}  // namespace animia::win::detail

#endif // __animia__animia__win32__ui_auto_h
