#ifndef __gui__theme_h
#define __gui__theme_h

#include <QStyle>

enum class Themes {
	OS,
	LIGHT,
	DARK
};

namespace Theme {

class Theme final {
	public:
		Theme(Themes theme = Themes::OS);
		void SetTheme(Themes theme);
		Themes GetTheme() const;
		bool IsInDarkTheme() const;
		void RepaintCurrentTheme();

	private:
		void SetToDarkTheme();
		void SetToLightTheme();
		void SetStyleSheet(Themes theme);
		Themes GetCurrentOSTheme() const;
		Themes theme;
};

} // namespace Theme

#endif // __gui__theme_h
