#include "gui/pages/seasons.h"

#include "core/anime_db.h"
#include "gui/widgets/anime_button.h"
#include "gui/layouts/flow_layout.h"

#include <QVBoxLayout>
#include <QToolBar>
#include <QFrame>
#include <QListWidget>
#include <QListWidgetItem>
#include <QMenu>
#include <QToolButton>

SeasonsPage::SeasonsPage(QWidget* parent) : QWidget(parent) {
	QVBoxLayout* full_layout = new QVBoxLayout(this);

	{
		/* Toolbar */
		QToolBar* toolbar = new QToolBar(this);
		toolbar->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
		toolbar->setIconSize(QSize(16, 16));
		toolbar->setMovable(false);

		{
			{
				QAction* action = new QAction(toolbar);
				action->setIcon(QIcon(":/icons/16x16/calendar-previous.png"));
				action->setToolTip(tr("Previous season"));
				toolbar->addAction(action);
			}

			{
				QAction* action = new QAction(toolbar);
				action->setIcon(QIcon(":/icons/16x16/calendar-next.png"));
				action->setToolTip(tr("Next season"));
				toolbar->addAction(action);
			}

			toolbar->addAction(QIcon(":/icons/16x16/calendar.png"), "Fall 2024"); // this must be named the name of the season
		}

		toolbar->addSeparator();

		{
			toolbar->addAction(QIcon(":/icons/16x16/arrow-circle-315.png"), tr("Refresh data"));
		}

		toolbar->addSeparator();

		{
			QToolButton* button = new QToolButton(toolbar);

			{
				/* links */
				QMenu* menu = new QMenu(button);
				menu->addAction("Airing status");
				menu->addAction("List status");
				menu->addAction("Type");
				button->setMenu(menu);
			}

			button->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
			button->setIcon(QIcon(":/icons/16x16/category.png"));
			button->setText("Group by:");
			button->setPopupMode(QToolButton::InstantPopup);
			toolbar->addWidget(button);
		}

		{
			QToolButton* button = new QToolButton(toolbar);

			{
				/* links */
				QMenu* menu = new QMenu(button);
				menu->addAction("Airing date");
				menu->addAction("Episodes");
				menu->addAction("Popularity");
				menu->addAction("Score");
				menu->addAction("Title");
				button->setMenu(menu);
			}

			button->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
			button->setIcon(QIcon(":/icons/16x16/sort-quantity-descending.png"));
			button->setText("Sort by:");
			button->setPopupMode(QToolButton::InstantPopup);
			toolbar->addWidget(button);
		}

		{
			QToolButton* button = new QToolButton(toolbar);

			{
				/* links */
				QMenu* menu = new QMenu(button);
				menu->addAction("Images");
				menu->addAction("Details");
				button->setMenu(menu);
			}

			button->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
			button->setIcon(QIcon(":/icons/16x16/ui-scroll-pane-detail.png"));
			button->setText("View:");
			button->setPopupMode(QToolButton::InstantPopup);
			toolbar->addWidget(button);
		}

		full_layout->addWidget(toolbar);
	}

	{
		QFrame* line = new QFrame(this);
		line->setFrameShape(QFrame::HLine);
		line->setFrameShadow(QFrame::Sunken);
		line->setLineWidth(1);
		full_layout->addWidget(line);
	}

	{
		buttons = new QListWidget(this);
		buttons->setFlow(QListView::LeftToRight);
		buttons->setWrapping(true);
		buttons->setContentsMargins(4, 4, 4, 4);
		buttons->setSpacing(2);
		buttons->setResizeMode(QListView::Adjust);

		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}
		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}
		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}
		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}

		full_layout->addWidget(buttons);
	}
}
