#ifndef __core__date_h
#define __core__date_h

#include "json/json_fwd.hpp"

#include <optional>

class QDate;

class Date {
	public:
		Date();
		Date(unsigned int y);
		Date(unsigned int y, unsigned int m, unsigned int d);
		Date(const QDate& date);
		Date(const nlohmann::json& json);
		bool IsValid() const;
		void SetYear(unsigned int y);
		void SetMonth(unsigned int m);
		void SetDay(unsigned int d);
		void VoidYear();
		void VoidMonth();
		void VoidDay();
		std::optional<unsigned int> GetYear() const;
		std::optional<unsigned int> GetMonth() const;
		std::optional<unsigned int> GetDay() const;
		QDate GetAsQDate() const;
		nlohmann::json GetAsAniListJson() const;

	private:
		std::optional<unsigned int> year;
		std::optional<unsigned int> month;
		std::optional<unsigned int> day;
};

#endif // __core__date_h
