#include "services/services.h"
#include "core/session.h"
#include "gui/dialog/settings.h"
#include "services/anilist.h"
#include <QMessageBox>

namespace Services {

void Synchronize() {
	switch (session.config.service) {
		case Anime::Services::ANILIST: AniList::GetAnimeList(); break;
		default: break;
	}
}

void UpdateAnimeEntry(int id) {
	switch (session.config.service) {
		case Anime::Services::ANILIST: AniList::UpdateAnimeEntry(id); break;
		default: break;
	}
}

bool Authorize() {
	switch (session.config.service) {
		case Anime::Services::ANILIST: return AniList::AuthorizeUser();
		default: return true;
	}
}

}; // namespace Services
