#include "core/ini.h"

namespace INI {

std::string GetIniString(const mINI::INIStructure& ini, const std::string& section, const std::string& key, const std::string& def) {
	if (!ini.has(section) || !ini.get(section).has(key))
		return def;

	return ini.get(section).get(key);
}

bool GetIniBool(const mINI::INIStructure& ini, const std::string& section, const std::string& key, bool def) {
	return Strings::ToBool(GetIniString(ini, section, key, ""), def);
}

}
