#include "core/anime_season_db.h"
#include "core/anime.h"
#include "core/anime_db.h"
#include "core/date.h"

namespace Anime::Season {

std::vector<int> GetAllAnimeForSeason(SeriesSeason season, Date::Year year) {
	std::vector<int> ret;

	for (const auto& [id, anime] : db.items) {
		std::optional<Date::Year> anime_year = anime.GetStartedDate().GetYear();
		if (anime.GetSeason() == season && anime_year && anime_year.value() == year)
			ret.push_back(id);
	}

	return ret;
}

}
