#ifndef __animia__animia__util__win32_h
#define __animia__animia__util__win32_h

#include <windows.h>
#include <subauth.h>

#include <memory>
#include <string>

namespace animia::internal::win32 {

struct HandleDeconstructor {
		using pointer = HANDLE;
		void operator()(pointer t) const { ::CloseHandle(t); };
};

using Handle = std::unique_ptr<HANDLE, HandleDeconstructor>;

/* ----------------------------------------------- */

std::string ToUtf8String(const std::wstring& string);
std::string ToUtf8String(const UNICODE_STRING& string);
std::wstring ToWstring(const std::string& string);

std::wstring GetFileNameFromPath(const std::wstring& path);
std::wstring GetFileNameWithoutExtension(const std::wstring& filename);

bool IsSystemDirectory(const std::string& path);
bool IsSystemDirectory(std::wstring path);

} // namespace animia::internal::win32

#endif // __animia__animia__util__win32_h