#ifndef __gui__ui_utils_h
#define __gui__ui_utils_h

#include <QLineEdit>
#include <QPlainTextEdit>
#include <QSize>
#include <QString>
#include <QWidget>

class QFrame;
class QLabel;

namespace TextWidgets {

class Header : public QWidget {
		Q_OBJECT

	public:
		Header(const QString& title, QWidget* parent = nullptr);
		void SetText(const QString& title);

	private:
		QLabel* static_text_title;
		QFrame* static_text_line;
};

class Paragraph : public QPlainTextEdit {
		Q_OBJECT

	public:
		Paragraph(const QString& text, QWidget* parent = nullptr);
		void SetText(const QString& text);
		QSize minimumSizeHint() const override;
		QSize sizeHint() const override;
};

class Line : public QLineEdit {
		Q_OBJECT

	public:
		Line(QWidget* parent = nullptr);
		Line(const QString& text, QWidget* parent = nullptr);
		void SetText(const QString& text);
};

class Title final : public Line {
		Q_OBJECT

	public:
		Title(const QString& title, QWidget* parent = nullptr);
};

class Section final : public QWidget {
		Q_OBJECT

	public:
		Section(const QString& title, const QString& data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* paragraph;
};

class LabelledSection final : public QWidget {
		Q_OBJECT

	public:
		LabelledSection(const QString& title, const QString& label, const QString& data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetLabels();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* labels;
		Paragraph* paragraph;
};

class SelectableSection final : public QWidget {
		Q_OBJECT

	public:
		SelectableSection(const QString& title, const QString& data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* paragraph;
};

class OneLineSection final : public QWidget {
		Q_OBJECT

	public:
		OneLineSection(const QString& title, const QString& data, QWidget* parent = nullptr);
		Header* GetHeader();
		Line* GetLine();

	private:
		Header* header;
		Line* line;
};

} // namespace TextWidgets

#endif // __gui__ui_utils_h
