#ifndef MINORI_GUI_PAGES_SEASONS_H_
#define MINORI_GUI_PAGES_SEASONS_H_

#include <QFrame>
#include <QThread>
#include <QToolButton>

#include "core/anime.h"
#include "core/date.h"

#include <utility>
#include <queue>

class QListWidget;
class QToolButton;

Q_DECLARE_METATYPE(Anime::Season);

class SeasonsPageSearchThread : public QThread {
	Q_OBJECT

public:
	SeasonsPageSearchThread(QObject* parent = nullptr);
	void AddToQueue(Anime::Season season);

protected:
	void run() override;

private:
	std::queue<Anime::Season> queue_;
	std::mutex queue_mutex_;

signals:
	void ReceivedSeason(Anime::Season season);
};

class SeasonsPage final : public QFrame {
	Q_OBJECT

public:
	SeasonsPage(QWidget* parent = nullptr);
	void SetSeason(Anime::Season season);
	void Refresh();

protected:
	QListWidget* buttons = nullptr;
	QToolButton season_button;

	Anime::Season season_;
};

#endif // MINORI_GUI_PAGES_SEASONS_H_
