#ifndef MINORI_GUI_WIDGETS_DROP_LIST_WIDGET_H_
#define MINORI_GUI_WIDGETS_DROP_LIST_WIDGET_H_

#include <QListWidget>
#include <QString>
#include <QWidget>

class QDragEnterEvent;
class QDragMoveEvent;
class QDropEvent;

class DroppableListWidget : public QListWidget {
	Q_OBJECT

public:
	explicit DroppableListWidget(QWidget* parent);

signals:
	void FilesDropped(QStringList list);

protected:
	void dragEnterEvent(QDragEnterEvent* event) override;
	void dragMoveEvent(QDragMoveEvent* event) override;
	void dropEvent(QDropEvent* event) override;
};

#endif // MINORI_GUI_WIDGETS_DROP_LIST_WIDGET_H_