#ifndef __gui__dialog__information_h
#define __gui__dialog__information_h

#include "core/anime.h"
#include "core/date.h"
#include <QDialog>
#include <functional>

class InformationDialog final : public QDialog {
		Q_OBJECT

	public:
		InformationDialog(Anime::Anime& anime, std::function<void()> accept, QWidget* parent = nullptr);

	private:
		void SaveData(Anime::Anime& anime);
		unsigned int _progress;
		unsigned int _score;
		bool _rewatching;
		Anime::ListStatus _status;
		std::string _notes;
		Date _started;
		Date _completed;
};

#endif // __gui__dialog__information_h
