#ifndef __gui__pages__statistics_h
#define __gui__pages__statistics_h

#include <QFrame>
#include <QWidget>
#include "gui/widgets/graph.h"

namespace TextWidgets {
class LabelledSection;
}

class StatisticsPage final : public QFrame {
		Q_OBJECT

	public:
		StatisticsPage(QWidget* parent = nullptr);
		void UpdateStatistics();

	protected:
		void showEvent(QShowEvent*) override;

	private:
		std::string MinutesToDateString(int minutes);
		std::string SecondsToDateString(int seconds);

		std::shared_ptr<TextWidgets::LabelledSection> _anime_list;
		std::shared_ptr<Graph<int>> _score_distribution_graph;
		std::shared_ptr<TextWidgets::LabelledSection> _application;
};

#endif // __gui__pages__statistics_h