#include "gui/widgets/anime_info.h"
#include "core/anime.h"
#include "core/strings.h"
#include "gui/translate/anime.h"
#include "gui/widgets/text.h"
#include <QHBoxLayout>
#include <QTextStream>

AnimeInfoWidget::AnimeInfoWidget(QWidget* parent) : QWidget(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);

	_title.reset(new TextWidgets::OneLineSection(tr("Alternative titles"), "", this));
	layout->addWidget(_title.get());

	_details.reset(new TextWidgets::LabelledSection(tr("Details"), new TextWidgets::LabelledSection(
	    tr("Details"), tr("Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:"), "", this), "", this));
	layout->addWidget(_details.get());

	_synopsis.reset(new TextWidgets::LabelledSection(tr("Synopsis"), "", this));
	_synopsis->GetParagraph()->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	layout->addWidget(_synopsis.get());
}

AnimeInfoWidget::AnimeInfoWidget(const Anime::Anime& anime, QWidget* parent) : AnimeInfoWidget(parent) {
	SetAnime(anime);
}

AnimeInfoWidget::SetAnime(const Anime::Anime& anime) {
	/* alt titles */
	_title->GetParagraph()->SetText(Strings::ToQString(Strings::Implode(anime.GetTitleSynonyms(), ", ")));

	/* details */
	QString details_data;
	QTextStream details_data_s(&details_data);
	details_data_s << Translate::ToString(anime.GetFormat()).c_str() << "\n"
	               << anime.GetEpisodes() << "\n"
	               << Translate::ToString(anime.GetUserStatus()).c_str() << "\n"
	               << Translate::ToString(anime.GetSeason()).c_str() << " " << anime.GetAirDate().GetYear() << "\n"
	               << Strings::Implode(anime.GetGenres(), ", ").c_str() << "\n"
	               << anime.GetAudienceScore() << "%";
	_details->GetParagraph()->SetText(Strings::ToQString(Strings::Implode(anime.GetTitleSynonyms(), ", ")));
	layout->addWidget();

	_synopsis->GetParagraph()->SetText(Strings::ToQString(Strings::Implode(anime.GetTitleSynonyms(), ", ")));
	layout->addWidget(synopsis);
}

#include "gui/widgets/moc_anime_info.cpp"
