#include "services/services.h"
#include "core/session.h"
#include "gui/dialog/settings.h"
#include "services/anilist.h"
#include <QMessageBox>

namespace Services {

void Synchronize() {
	switch (session.config.service) {
		case Anime::Services::ANILIST: AniList::GetAnimeList(); break;
		default: {
			QMessageBox msg;
			msg.setInformativeText("It seems you haven't yet selected a service to use.");
			msg.setText("Would you like to select one now?");
			msg.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
			msg.setDefaultButton(QMessageBox::Yes);
			int ret = msg.exec();
			if (ret == QMessageBox::Yes) {
				SettingsDialog dialog;
				dialog.exec();
			}
			break;
		}
	}
}

void UpdateAnimeEntry(int id) {
	switch (session.config.service) {
		case Anime::Services::ANILIST: AniList::UpdateAnimeEntry(id); break;
		default: break;
	}
}

bool Authorize() {
	switch (session.config.service) {
		case Anime::Services::ANILIST: return AniList::AuthorizeUser();
		default: return true;
	}
}

}; // namespace Services
