#include "track/media.h"
#include "animia.h"
#include "anitomy/anitomy.h"
#include "core/filesystem.h"
#include "core/strings.h"
#include <string>
#include <vector>
#include <unordered_map>
#include <QDebug>

namespace Track {
namespace Media {

Filesystem::Path GetCurrentPlaying() {
	/* getting all open files */
	std::vector<int> pids = Animia::get_all_pids();
	for (int i : pids) {
		if (Animia::get_process_name(i) == "vlc") {
			std::vector<std::string> files = Animia::filter_system_files(Animia::get_open_files(i));
			for (std::string s : files) {
				qDebug() << Strings::ToQString(s);
				Filesystem::Path p(s);
				if (p.Extension() == "mp4")
					return p;
			}
		}
	}
	return Filesystem::Path();
}

std::unordered_map<std::string, std::string> GetMapFromElements(const anitomy::Elements& elements) {
	/* there are way more than this in anitomy, but we only need basic information 
	   I also just prefer using maps than using the ".get()" stuff which is why I'm doing this */
	std::unordered_map<std::string, std::string> ret;

	ret["title"] = Strings::ToUtf8String(elements.get(anitomy::kElementAnimeTitle));
	ret["filename"] = Strings::ToUtf8String(elements.get(anitomy::kElementFileName));
	ret["language"] = Strings::ToUtf8String(elements.get(anitomy::kElementLanguage));
	ret["group"] = Strings::ToUtf8String(elements.get(anitomy::kElementReleaseGroup));
	ret["episode"] = Strings::ToUtf8String(elements.get(anitomy::kElementEpisodeNumber));

	return ret;
}

std::unordered_map<std::string, std::string> GetFileElements(Filesystem::Path path) {
	anitomy::Anitomy anitomy;
	anitomy.Parse(Strings::ToWstring(path.Basename()));

	return GetMapFromElements(anitomy.elements());
}

} // namespace Media
} // namespace Track
