#ifndef __core__date_h
#define __core__date_h

#include "json/json_fwd.hpp"

class QDate;

class Date {
	public:
		Date();
		Date(unsigned int y);
		Date(unsigned int y, unsigned int m, unsigned int d);
		Date(const QDate& date);
		Date(const nlohmann::json& json);
		bool IsValid() const;
		void SetYear(unsigned int y);
		void SetMonth(unsigned int m);
		void SetDay(unsigned int d);
		void VoidYear();
		void VoidMonth();
		void VoidDay();
		unsigned int GetYear() const;
		unsigned int GetMonth() const;
		unsigned int GetDay() const;
		QDate GetAsQDate() const;
		nlohmann::json GetAsAniListJson() const;
		bool operator<(const Date& other) const;
		bool operator>(const Date& other) const;
		bool operator<=(const Date& other) const;
		bool operator>=(const Date& other) const;

	private:
		/* this implementation sucks and we should really use a struct instead */
		template<typename T>
		struct OptionalNumber {
			public:
				T Get() const { return enabled ? num : 0; }
				bool Enabled() const { return enabled; }
				void Set(T n) { num = n; enabled = true; }
				void Void() { num = 0; enabled = false; }

			protected:
				T num = 0;
				bool enabled = false;
		};

		OptionalNumber<unsigned int> year;
		OptionalNumber<unsigned int> month;
		OptionalNumber<unsigned int> day;
};

#endif // __core__date_h
