#include "animone.h"
#include "animone/fd.h"
#include "animone/strategies.h"
#include "animone/types.h"
#include "animone/util.h"
#include "animone/win.h"

#include <set>
#include <string>
#include <vector>

namespace animone {

namespace internal {

static bool IsExecutableInList(const Player& player, const std::string& name) {
	std::string stem;
#ifdef WIN32
	if (!util::Stem(name, stem))
#endif
		stem = name;

	for (const auto& pattern : player.executables)
		if (util::CheckPattern(pattern, stem))
			return true;

	return false;
}

static bool IsWindowInList(const Player& player, const Window& window) {
	for (const auto& pattern : player.windows)
		if (util::CheckPattern(pattern, window.class_name))
			return true;

	return false;
}

static bool PlayerHasStrategy(const Player& player, const Strategy& strategy) {
	for (const auto& pstrategy : player.strategies)
		if (pstrategy == strategy)
			return true;

	return false;
}

} // namespace internal

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results) {
	auto window_proc = [&](const Process& process, const Window& window) -> bool {
		for (const auto& player : players) {
			if (internal::IsWindowInList(player, window))
				results.push_back({player, process, window, {}});
		}

		return true;
	};

	if (internal::EnumerateWindows(window_proc))
		return internal::ApplyStrategies(results);

	/* fallback, enumerate over open processes instead */
	auto process_proc = [&](const Process& process) -> bool {
		for (const auto& player : players)
			if (internal::IsExecutableInList(player, process.name))
				results.push_back({player, process, {}, {}});

		return true;
	};

	if (internal::EnumerateOpenProcesses(process_proc))
		return internal::ApplyStrategies(results);

	return false;
}

} // namespace animone
