#ifndef __gui__pages__now_playing_h
#define __gui__pages__now_playing_h

#include "gui/widgets/anime_info.h"
#include "gui/widgets/poster.h"
#include "gui/widgets/text.h"

#include <QFrame>
#include <memory>
#include <unordered_map>

class QStackedWidget;

namespace Anime {
class Anime;
}

namespace anitomy {
class Elements;
}

namespace NowPlayingPages {

class Default : public QWidget {
	Q_OBJECT

public:
	Default(QWidget* parent = nullptr);
};

class Playing : public QWidget {
	Q_OBJECT

public:
	Playing(QWidget* parent = nullptr);
	void SetPlayingAnime(const Anime::Anime& anime, const anitomy::Elements& info);
	int GetPlayingAnime();

private:
	int _id = 0;
	int _episode = 0;
	std::unique_ptr<QWidget> _main = nullptr;
	std::unique_ptr<TextWidgets::Title> _title = nullptr;
	std::unique_ptr<AnimeInfoWidget> _info = nullptr;
	std::unique_ptr<QWidget> _sidebar = nullptr;
	std::unique_ptr<Poster> _poster = nullptr;
};

} // namespace NowPlayingPages

class NowPlayingPage final : public QFrame {
	Q_OBJECT

public:
	NowPlayingPage(QWidget* parent = nullptr);
	void SetDefault();
	void SetPlaying(const Anime::Anime& anime, const anitomy::Elements& episodes);
	int GetPlayingId();

private:
	QStackedWidget* stack;
};

#endif // __gui__pages__now_playing_h
