#include "animia/fd.h"

#ifdef WIN32
#	include "animia/fd/win32.h"
#elif defined(LINUX)
#	include "animia/fd/linux.h"
#elif defined(UNIX)
#	include "animia/fd/bsd.h"
#endif

namespace animia::internal {

#ifdef WIN32
win32::Win32FdTools os_fd;
#elif defined(LINUX)
linux::LinuxFdTools os_fd;
#elif defined(UNIX)
unix::UnixFdTools os_fd;
#else
BaseFdTools os_fd;
#endif

BaseFdTools& fd = os_fd;

}
