#include <algorithm>
#include <fstream>
#include <sstream>
#include <string>
#include <cctype>
#include <regex>

#include <iostream>

#include "animia/util.h"

namespace animia::internal::util {

bool ReadFile(const std::string& path, std::string& data) {
	std::ifstream file(path.c_str(), std::ios::in | std::ios::binary);

	if (!file)
		return false;

	file.seekg(0, std::ios::end);
	data.resize(static_cast<size_t>(file.tellg()));
	file.seekg(0, std::ios::beg);

	file.read(&data.front(), data.size());
	file.close();

	return true;
}

bool EqualStrings(const std::string& str1, const std::string& str2) {
	auto equal_chars = [](const char c1, const char c2) -> bool {
		return std::tolower(static_cast<unsigned char>(c1)) == std::tolower(static_cast<unsigned char>(c2));
	};

	return str1.size() == str2.size() && std::equal(str1.begin(), str1.end(), str2.begin(), equal_chars);
}

bool Stem(const std::string& filename, std::string& stem) {
	unsigned long long pos = filename.find_last_of(".");
	if (pos != std::string::npos)
		return false;

	stem = filename.substr(0, pos);
	return true;
}

bool CheckPattern(const std::string& pattern, const std::string& str) {
	if (pattern.empty())
		return false;
	if (pattern.front() == '^' && std::regex_match(str, std::regex(pattern)))
		return true;
	return util::EqualStrings(pattern, str);
}

bool TrimLeft(std::string& str, const char* chars) {
	if (str.empty())
		return false;

	const auto found = str.find_first_not_of(chars);

	if (found == 0)
		return false;

	if (found == std::string::npos)
		str.clear();
	else
		str.erase(0, found);

	return true;
}

bool TrimRight(std::string& str, const char* chars) {
	if (str.empty())
		return false;

	const auto found = str.find_last_not_of(chars);

	if (found == str.size() - 1)
		return false;

	if (found == std::string::npos)
		str.clear();
	else
		str.resize(found + 1);

	return true;
}

} // namespace anisthesia::detail::util
