#include "track/media.h"
#include "track/constants.h"
#include "animia.h"
#include "anitomy/anitomy.h"
#include "core/filesystem.h"
#include "core/strings.h"
#include "core/session.h"
#include <string>
#include <unordered_map>
#include <vector>
#include <iostream>
#include <QFile>
#include <QTextStream>

namespace Track {
namespace Media {

static bool GetCurrentlyPlayingResults(std::vector<animia::Result>& results) {
	std::vector<animia::Player> players;

	players.reserve(session.config.recognition.players.size());
	for (const auto& [enabled, player] : session.config.recognition.players)
		if (enabled && player.type == animia::PlayerType::Default)
			players.push_back(player);

	if (!animia::GetResults(players, results))
		return false;

	return true;
}

/* meh */
bool GetCurrentlyPlaying(std::vector<std::string>& vec) {
	std::vector<animia::Result> results;

	if (!GetCurrentlyPlayingResults(results))
		return false;

	bool success = false;

	for (const auto& result : results) {
		for (const auto& media : result.media) {
			for (const auto& info : media.information) {
				std::cout << static_cast<int>(info.type) << ": " << info.value << std::endl;
				vec.push_back(info.value);
				success |= true;
			}
		}
	}

	return success;
}

/* this sucks. use anitomy directly like a real man */
std::unordered_map<std::string, std::string> GetMapFromElements(const anitomy::Elements& elements) {
	std::unordered_map<std::string, std::string> ret;

	ret["title"] = Strings::ToUtf8String(elements.get(anitomy::kElementAnimeTitle));
	ret["filename"] = Strings::ToUtf8String(elements.get(anitomy::kElementFileName));
	ret["language"] = Strings::ToUtf8String(elements.get(anitomy::kElementLanguage));
	ret["group"] = Strings::ToUtf8String(elements.get(anitomy::kElementReleaseGroup));
	ret["episode"] = Strings::ToUtf8String(elements.get(anitomy::kElementEpisodeNumber));
	ret["resolution"] = Strings::ToUtf8String(elements.get(anitomy::kElementVideoResolution));

	return ret;
}

std::unordered_map<std::string, std::string> GetFileElements(const std::string& basename) {
	anitomy::Anitomy anitomy;
	anitomy.Parse(Strings::ToWstring(basename));

	return GetMapFromElements(anitomy.elements());
}

std::unordered_map<std::string, std::string> GetFileElements(const std::filesystem::path& path) {
	anitomy::Anitomy anitomy;
	anitomy.Parse(path.filename().wstring());

	return GetMapFromElements(anitomy.elements());
}

} // namespace Media
} // namespace Track
