#ifndef MINORI_CORE_TIME_H_
#define MINORI_CORE_TIME_H_

#include <cstdint>
#include <string>
namespace Time {

/* this is in SECONDS */
using Timestamp = uint64_t;

enum class Units {
	Seconds,
	Minutes
};

std::string GetSecondsAsRelativeString(Timestamp length);
std::string GetSecondsAsAbsoluteString(Units unit_cutoff, Timestamp amount, double unit_in_seconds = 1.0);

int64_t GetSystemTime();

}; // namespace Time

#endif // MINORI_CORE_TIME_H_