#include "animone/win.h"

#ifdef USE_WIN32
#	include "animone/win/win32.h"
#endif

#ifdef USE_MACOSX
#	include "animone/win/quartz.h"
#endif

#ifdef USE_X11
#	include "animone/win/x11.h"
#endif

namespace animone::internal {

bool EnumerateWindows(window_proc_t window_proc) {
	bool success = false;

#ifdef USE_WIN32
	success |= win32::EnumerateWindows(window_proc);
#endif

#ifdef USE_MACOSX
	success |= quartz::EnumerateWindows(window_proc);
#endif

#ifdef USE_X11
	success |= x11::EnumerateWindows(window_proc);
#endif

	return success;
}

} // namespace animone::internal
