#ifndef MINORI_CORE_BIT_CAST_H_
#define MINORI_CORE_BIT_CAST_H_

/* XXX need to move more "core" stuff into the minori namespace */

#include <type_traits>
#include <memory>
#include <cstring>

namespace minori {

/* C++17 doesn't have this unfortunately */
template<typename To, class From>
To BitCast(From from) {
	static_assert(sizeof(From) == sizeof(To), "Types must match sizes");
	static_assert(std::is_pod<From>::value, "Requires POD input");
	static_assert(std::is_pod<To>::value, "Requires POD output");

	To to;
	std::memcpy(std::addressof(to), std::addressof(from), sizeof(from));
	return to;
}

}

#endif /* MINORI_CORE_BIT_CAST_H_ */
