#ifndef MINORI_LIBRARY_LIBRARY_H_
#define MINORI_LIBRARY_LIBRARY_H_

#include "library/library.h"

#include <optional>
#include <filesystem>
#include <unordered_map>

namespace Library {

class Database final {
public:
	std::optional<std::filesystem::path> GetAnimeFolder(int id);
	void Refresh();
	void Refresh(int id);

	// Anime episodes. Indexed as `folders[id][episode]'
	std::unordered_map<int, std::unordered_map<int, std::filesystem::path>> items;

private:
	void Refresh(std::optional<int> find_id);
};

extern Database db;

} // namespace Library

#endif // MINORI_LIBRARY_LIBRARY_H_
