#include "core/byte_stream.h"

ByteStream::ByteStream(std::uint8_t *bytes, std::size_t size) {
	bytes_ = bytes;
	size_ = size;
}

void ByteStream::ResetOffset() {
	offset_ = 0;
}

void ByteStream::SetEndianness(ByteStream::ByteOrder endian) {
	endian_ = endian;
}

bool ByteStream::ReadString(std::string& str, std::size_t size) {
	if (offset_ + size >= size_)
		return false;

	str.assign(reinterpret_cast<const char *>(bytes_ + offset_), size);
	Advance(size);
	return true;
}

bool ByteStream::Advance(std::size_t amount) {
	if (offset_ + amount >= size_)
		return false;

	offset_ += amount;
	return true;
}
