#include "core/anime_db.h"
#include "core/anime.h"
#include "core/strings.h"
#include <QDebug>

namespace Anime {

int Database::GetTotalAnimeAmount() {
	int total = 0;
	for (const auto& a : items) {
		if (a.second.IsInUserList())
			total++;
	}
	return total;
}

int Database::GetListsAnimeAmount(ListStatus status) {
	if (status == ListStatus::NOT_IN_LIST)
		return 0;
	int total = 0;
	for (const auto& a : items) {
		if (a.second.IsInUserList() && a.second.GetUserStatus() == status)
			total++;
	}
	return total;
}

int Database::GetTotalEpisodeAmount() {
	int total = 0;
	for (const auto& a : items) {
		if (a.second.IsInUserList()) {
			total += a.second.GetUserRewatchedTimes() * a.second.GetEpisodes();
			total += a.second.GetUserProgress();
		}
	}
	return total;
}

/* Returns the total watched amount in minutes. */
int Database::GetTotalWatchedAmount() {
	int total = 0;
	for (const auto& a : items) {
		if (a.second.IsInUserList()) {
			total += a.second.GetDuration() * a.second.GetUserProgress();
			total += a.second.GetEpisodes() * a.second.GetDuration() * a.second.GetUserRewatchedTimes();
		}
	}
	return total;
}

/* Returns the total planned amount in minutes.
   Note that we should probably limit progress to the
   amount of episodes, as AniList will let you
   set episode counts up to 32768. But that should
   rather be handled elsewhere. */
int Database::GetTotalPlannedAmount() {
	int total = 0;
	for (const auto& a : items) {
		if (a.second.IsInUserList())
			total += a.second.GetDuration() * (a.second.GetEpisodes() - a.second.GetUserProgress());
	}
	return total;
}

/* I'm sure many will appreciate this being called an
   "average" instead of a "mean" */
double Database::GetAverageScore() {
	double avg = 0;
	int amt = 0;
	for (const auto& a : items) {
		if (a.second.IsInUserList() && a.second.GetUserScore()) {
			avg += a.second.GetUserScore();
			amt++;
		}
	}
	return avg / amt;
}

double Database::GetScoreDeviation() {
	double squares_sum = 0, avg = GetAverageScore();
	int amt = 0;
	for (const auto& a : items) {
		if (a.second.IsInUserList() && a.second.GetUserScore()) {
			squares_sum += std::pow(static_cast<double>(a.second.GetUserScore()) - avg, 2);
			amt++;
		}
	}
	return (amt > 0) ? std::sqrt(squares_sum / amt) : 0;
}

int Database::GetAnimeFromTitle(std::string title) {
	if (title.empty())
		return 0;
	for (const auto& a : items) {
		if (a.second.GetUserPreferredTitle().find(title) != std::string::npos)
			return a.second.GetId();
		for (const auto& t : a.second.GetTitleSynonyms()) {
			if (t.find(title) != std::string::npos) {
				return a.second.GetId();
			}
		}
	}
	return 0;
}

Database db;

} // namespace Anime