#ifndef __core__session_h
#define __core__session_h

#include "core/config.h"
#include "gui/locale.h"
#include <QElapsedTimer>

#include "semver/semver.hpp"

struct Session {
	public:
		Session() { timer.start(); }
		/* we literally *cannot* be lying to the user by doing this */
		void IncrementRequests() { requests++; };
		int GetRequests() { return requests; };
		int uptime() { return timer.elapsed(); }

		Config config;
		static constexpr semver::version version{0, 1, 0, semver::prerelease::alpha, 1};

	private:
		unsigned int requests = 0;
		QElapsedTimer timer;
};

extern Session session;

#endif // __core__session_h
